Pour récupérer le prix de chaque appel, utilisez l'API Detail Records (CDR) de Telnyx. Voici les étapes à suivre :

Méthode : API Detail Records
Étape 1 : Faire une requête API

Utilisez l'endpoint API pour rechercher les enregistrements détaillés des appels :

http


GET /v2/detail_records?filter[record_type]=<type>&filter[date_range]=<range>
Host: api.telnyx.com
Authorization: Bearer YOUR_API_KEY
Types d'enregistrements disponibles :

sip-trunking : Pour les appels SIP standard
call-control : Pour les appels programmables (Programmable Voice)
webrtc : Pour les appels WebRTC
texml : Pour les appels TeXML
Étape 2 : Filtres disponibles

Vous pouvez affiner vos résultats avec les filtres suivants :

date_range : today, yesterday, last_7_days, last_30_days, etc.
start_timestamp et end_timestamp : Pour des périodes personnalisées
from_number : Numéro appelant
to_number : Numéro appelé
direction : inbound ou outbound
Étape 3 : Interpréter les champs de prix

Chaque enregistrement contient les informations de tarification suivantes :

rate : Le tarif par unité (par exemple, par minute)
cost : Le coût total de l'appel
currency : La devise (USD, EUR, etc.)
Exemple de réponse :

json


{
    "data": [
        {
            "rate": "0.002",
            "cost": "0.002",
            "currency": "USD",
            "caller_number": "+15127376291",
            "dest_number": "+18008648331",
            "call_id": "064d6317-4837-41e2-8795-cfc304ced4d1",
            "started_at": "2024-12-11T17:42:30Z",
            "finished_at": "2024-12-11T17:43:24Z"
        }
    ]
}
Exemple pratique en Python :

python


import requests

url = "https://api.telnyx.com/v2/detail_records"
headers = {
    "Authorization": "Bearer YOUR_API_KEY"
}
params = {
    "filter[record_type]": "sip-trunking",
    "filter[date_range]": "today"
}

response = requests.get(url, headers=headers, params=params)
records = response.json()

for record in records['data']:
    print(f"Appel: {record['caller_number']} -> {record['dest_number']}")
    print(f"Prix: {record['cost']} {record['currency']}")
Documentation utile :

API Detail Records↗
Troubleshooting Detail Records↗


https://developers.telnyx.com/api/detail-records/search-detail-records

https://developers.telnyx.com/docs/voice/webrtc/troubleshooting/detail-records

# Search detail records

Search for any detail record across the Telnyx Platform

Search detail records API{"@context":"http://schema.org","@type":"TechArticle","headline":"Search detail records API","description":"Search for any detail record across the Telnyx Platform","url":"https://developers.telnyx.com/api/detail-records/search-detail-records","author":{"@type":"Organization","name":"Telnyx"},"publisher":{"@type":"Organization","name":"Telnyx","url":"https://www.telnyx.com","logo":{"@type":"ImageObject","url":"https://developers.telnyx.com/img/logo.svg","width":270,"height":108}}}Copy for LLMView as MarkdownSearch detail records
GET https://api.telnyx.com/v2/detail_records
Search for any detail record across the Telnyx Platform
Request ​
Responses ​200: SuccessfulSchema SchemaExample (auto)Test endpoint

## Query Parameters
- `filter` (object): Filter records on a given record attribute and value. Example: filter[status]=delivered. Required: filter[record_type] must be specified. *Examples:* filter[record_type]=messaging filter[record_type]=messagingfilter[record_type]=verifyfilter[date_range]=todayfilter[date_range]=yesterdayfilter[date_range]=last_monthfilter[created_at][gte]=2021-06-22filter[created_at][lt]=2021-06-23filter[direction]=inboundfilter[cld][contains]=456filter[cld][starts_with]=123filter[cld][ends_with]=789Searches for messaging detail records *Example:* `messaging` Searches for verify detail records *Example:* `verify` Searches for records with timestamp starting at `00:00:00` of the current day *Example:* `today` Searches for records with timestamp starting at `00:00:00` of yesterday *Example:* `yesterday` Searches for records with timestamp starting at `00:00:00` on the first day of the month *Example:* `last_month` Searches for records with `created_at` starting at `2021-06-22` *Example:* `2021-06-22` Searches for records with `created_at` ending at `2021-06-22` *Example:* `2021-06-23` Searches for records which have the property `direction` equal to `inbound` *Example:* `inbound` Searches for records which have the property `cld` containing the pattern `456` *Example:* `456` Searches for records which have the property `cld` starting with the prefix `123` *Example:* `123` Searches for records which have the property `cld` ending with the suffix `789` *Example:* `789`
- `sort` (string[]): Specifies the sort order for results. Example: sort=-created_at *Examples:* sort=created_at sort=created_atsort=-created_atSorts search results using the `created_at` date-time in ascending order *Example:* `created_at` Sorts search results using the `created_at` date-time in descending order *Example:* `created_at`
- `page` (object): Consolidated page parameter (deepObject style). Originally: page[number], page[size] *Examples:* page[number]=1&page[size]=20 page[number]=1&page[size]=20page[number]=2&page[size]=20page[number]=1&page[size]=50Default pagination with first page and 20 items per page *Example:* `{"number":1,"size":20}` Second page with 20 items per page *Example:* `{"number":2,"size":20}` First page with maximum 50 items per page *Example:* `{"number":1,"size":50}`

## Response

## Response Schema - data
- `data` (object[]) [required]: Array [oneOfMessage MessageConferenceConference ParticipantAMDVerify 2FASim Card UsageMedia Storage]
  - `uuid` (string): Unique identifier of the message
  - `user_id` (string): Identifier of the Telnyx account who owns the message
  - `completed_at` (string<date-time>): Message completion time
  - `created_at` (string<date-time>): Message creation time
  - `updated_at` (string<date-time>): Message updated time
  - `sent_at` (string<date-time>): Time when the message was sent
  - `carrier` (string): Country-specific carrier used to send or receive the message
  - `carrier_fee` (string): Fee charged by certain carriers in order to deliver certain message types. Telnyx passes this fee on to the customer according to our pricing table
  - `cld` (string): The recipient of the message (to parameter in the Messaging API)
  - `cli` (string): The sender of the message (from parameter in the Messaging API). For Alphanumeric ID messages, this is the sender ID value
  - `country_code` (string): Two-letter representation of the country of the cld property using the ISO 3166-1 alpha-2 format
  - `delivery_status` (string): Final webhook delivery status
  - `delivery_status_failover_url` (string): Failover customer-provided URL which Telnyx posts delivery status webhooks to
  - `delivery_status_webhook_url` (string): Primary customer-provided URL which Telnyx posts delivery status webhooks to
  - `direction` (string): *Possible values:* [`inbound` , `outbound` ]Logical direction of the message from the Telnyx customer's perspective. It's inbound when the Telnyx customer receives the message, or outbound otherwise
  - `fteu` (boolean): Indicates whether this is a Free-To-End-User (FTEU) short code message
  - `mcc` (string): Mobile country code. Only available for certain products, such as Global Outbound-Only from Alphanumeric Sender ID
  - `mnc` (string): Mobile network code. Only available for certain products, such as Global Outbound-Only from Alphanumeric Sender ID
  - `message_type` (string): *Possible values:* [`SMS` , `MMS` , `RCS` ]Describes the Messaging service used to send the message. Available services are: Short Message Service (SMS), Multimedia Messaging Service (MMS), and Rich Communication Services (RCS)
  - `on_net` (boolean): Indicates whether both sender and recipient numbers are Telnyx-managed
  - `profile_id` (string): Unique identifier of the Messaging Profile used to send or receive the message
  - `profile_name` (string): Name of the Messaging Profile used to send or receive the message
  - `source_country_code` (string): Two-letter representation of the country of the cli property using the ISO 3166-1 alpha-2 format
  - `status` (string): *Possible values:* [`gw_timeout` , `delivered` , `dlr_unconfirmed` , `dlr_timeout` , `received` , `gw_reject` , `failed` ]Final status of the message after the delivery attempt
  - `tags` (string): Comma-separated tags assigned to the Telnyx number associated with the message
  - `rate` (string): Currency amount per billing unit used to calculate the Telnyx billing cost
  - `currency` (string): Telnyx account currency used to describe monetary values, including billing cost
  - `cost` (string): Amount, in the user currency, for the Telnyx billing cost
  - `errors` (string[]): Telnyx API error codes returned by the Telnyx gateway
  - `parts` (integer): Number of message parts. The message is broken down in multiple parts when its length surpasses the limit of 160 characters
  - `record_type` (string) [required]: *Default value:* `message_detail_record` Identifies the record schema
  - `id` (string): Conference id
  - `name` (string): Conference name
  - `user_id` (string): User id
  - `started_at` (string<date-time>): Conference start time
  - `ended_at` (string<date-time>): Conference end time
  - `expires_at` (string<date-time>): Conference expiry time
  - `region` (string): Region where the conference is hosted
  - `call_leg_id` (string): Telnyx UUID that identifies the conference call leg
  - `call_session_id` (string): Telnyx UUID that identifies with conference call session
  - `connection_id` (string): Connection id
  - `call_sec` (integer): Duration of the conference call in seconds
  - `participant_count` (integer): Number of participants that joined the conference call
  - `participant_call_sec` (integer): Sum of the conference call duration for all participants in seconds
  - `is_telnyx_billable` (boolean): Indicates whether Telnyx billing charges might be applicable
  - `record_type` (string) [required]: *Default value:* `conference_detail_record`
  - `id` (string): Participant id
  - `user_id` (string): User id
  - `conference_id` (string): Conference id
  - `joined_at` (string<date-time>): Participant join time
  - `left_at` (string<date-time>): Participant leave time
  - `destination_number` (string): Number called by the participant to join the conference
  - `originating_number` (string): Participant origin number used in the conference call
  - `call_leg_id` (string): Telnyx UUID that identifies the conference call leg
  - `call_session_id` (string): Telnyx UUID that identifies with conference call session
  - `call_sec` (integer): Duration of the conference call in seconds
  - `billed_sec` (integer): Duration of the conference call for billing purposes
  - `is_telnyx_billable` (boolean): Indicates whether Telnyx billing charges might be applicable
  - `rate` (string): Currency amount per billing unit used to calculate the Telnyx billing cost
  - `rate_measured_in` (string): Billing unit used to calculate the Telnyx billing cost
  - `cost` (string): Currency amount for Telnyx billing cost
  - `currency` (string): Telnyx account currency used to describe monetary values, including billing cost
  - `record_type` (string) [required]: *Default value:* `conference_participant_detail_record`
  - `id` (string): Feature invocation id
  - `invoked_at` (string<date-time>): Feature invocation time
  - `feature` (string): *Possible values:* [`PREMIUM` ]Feature name
  - `tags` (string): User-provided tags
  - `billing_group_id` (string): Billing Group id
  - `billing_group_name` (string): Name of the Billing Group specified in billing_group_id
  - `connection_id` (string): Connection id
  - `connection_name` (string): Connection name
  - `call_leg_id` (string): Telnyx UUID that identifies the related call leg
  - `call_session_id` (string): Telnyx UUID that identifies the related call session
  - `is_telnyx_billable` (boolean): Indicates whether Telnyx billing charges might be applicable
  - `rate` (string): Currency amount per billing unit used to calculate the Telnyx billing cost
  - `rate_measured_in` (string): Billing unit used to calculate the Telnyx billing cost
  - `cost` (string): Currency amount for Telnyx billing cost
  - `currency` (string): Telnyx account currency used to describe monetary values, including billing cost
  - `record_type` (string) [required]: *Default value:* `amd_detail_record`
  - `id` (string<uuid>): Unique ID of the verification
  - `verify_profile_id` (string<uuid>)
  - `delivery_status` (string)
  - `verification_status` (string)
  - `destination_phone_number` (string): E.164 formatted phone number
  - `verify_channel_type` (string): *Possible values:* [`sms` , `psd2` , `call` , `flashcall` ]Depending on the type of verification, the `verify_channel_id` points to one of the following channel ids; verify_channel_type | verify_channel_id ------------------- | ----------------- sms, psd2 | messaging_id call, flashcall | call_control_id
  - `verify_channel_id` (string<uuid>)
  - `created_at` (string<date-time>)
  - `updated_at` (string<date-time>)
  - `rate` (string): Currency amount per billing unit used to calculate the Telnyx billing costs
  - `rate_measured_in` (string): Billing unit used to calculate the Telnyx billing costs
  - `verify_usage_fee` (string): Currency amount for Verify Usage Fee
  - `currency` (string): Telnyx account currency used to describe monetary values, including billing costs
  - `record_type` (string) [required]: *Default value:* `verification_detail_record`
  - `id` (string<uuid>): Unique identifier for this SIM Card Usage
  - `created_at` (string<date-time>): Event creation time
  - `closed_at` (string<date-time>): Event close time
  - `ip_address` (string): Ip address that generated the event
  - `downlink_data` (number): Number of megabytes downloaded
  - `imsi` (string): International Mobile Subscriber Identity
  - `mcc` (string): Mobile country code
  - `mnc` (string): Mobile network code
  - `currency` (string): Telnyx account currency used to describe monetary values, including billing cost
  - `data_unit` (string): Unit of wireless link consumption
  - `data_rate` (string): Currency amount per billing unit used to calculate the Telnyx billing cost
  - `sim_group_name` (string): Sim group name for sim card
  - `sim_card_id` (string): Unique identifier for SIM card
  - `sim_group_id` (string): Unique identifier for SIM group
  - `sim_card_tags` (string): User-provided tags
  - `phone_number` (string): Telephone number associated to SIM card
  - `uplink_data` (number): Number of megabytes uploaded
  - `data_cost` (number): Data cost
  - `record_type` (string) [required]: *Default value:* `sim_card_usage`
  - `id` (string): Unique identifier for the Media Storage Event
  - `created_at` (string<date-time>): Event creation time
  - `asset_id` (string): Asset id
  - `user_id` (string): User id
  - `org_id` (string): Organization owner id
  - `action_type` (string): Type of action performed against the Media Storage API
  - `link_channel_type` (string): Link channel type
  - `link_channel_id` (string): Link channel id
  - `status` (string): Request status
  - `webhook_id` (string): Webhook id
  - `rate` (string): Currency amount per billing unit used to calculate the Telnyx billing cost
  - `rate_measured_in` (string): Billing unit used to calculate the Telnyx billing cost
  - `cost` (string): Currency amount for Telnyx billing cost
  - `currency` (string): Telnyx account currency used to describe monetary values, including billing cost
  - `record_type` (string) [required]: *Default value:* `media_storage`
- `meta` (object)
  - `total_pages` (integer<int32>)
  - `total_results` (integer<int32>)
  - `page_number` (integer<int32>)
  - `page_size` (integer<int32>)

## Request samples
```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

```
curl -L 'https://api.telnyx.com/v2/detail_records' \-H 'Accept: application/json' \-H 'Authorization: Bearer <TOKEN>'
```

## Response samples
```
{  "data": [    {      "uuid": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "user_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "completed_at": "2020-07-01T00:00:00Z",      "created_at": "2020-07-01T00:00:00Z",      "updated_at": "2020-07-01T00:00:00Z",      "sent_at": "2020-07-01T00:00:00Z",      "carrier": "T-Mobile USA",      "carrier_fee": "0.003",      "cld": "+1555123456",      "cli": "+1555123456",      "country_code": "US",      "delivery_status": "success: webhook succeeded",      "delivery_status_failover_url": "https://api.example.com/sms/telnyx/inbound",      "delivery_status_webhook_url": "https://api.example.com/sms/telnyx/inbound",      "direction": "outbound",      "fteu": false,      "mcc": "204",      "mnc": "01",      "message_type": "SMS",      "on_net": true,      "profile_id": "30ef55db-c4a2-4c4a-9804-a68077973d07",      "profile_name": "My Messaging Profile",      "source_country_code": "US",      "status": "delivered",      "tags": "tag1,tag2,tag3",      "rate": "0.003",      "currency": "USD",      "cost": "0.003",      "errors": [        "40001"      ],      "parts": 2,      "record_type": "message_detail_record"    },    {      "id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "name": "My Conference",      "user_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "started_at": "2020-07-01T00:00:00-06:00",      "ended_at": "2020-07-01T00:00:00-06:00",      "expires_at": "2020-07-01T00:00:00-06:00",      "region": "ch1",      "call_leg_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "call_session_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "connection_id": "1583941447772537867",      "call_sec": 100,      "participant_count": 5,      "participant_call_sec": 100,      "is_telnyx_billable": false,      "record_type": "conference_detail_record"    },    {      "id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "user_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "conference_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "joined_at": "2020-07-01T00:00:00-06:00",      "left_at": "2020-07-01T00:00:00-06:00",      "destination_number": "+18005550199",      "originating_number": "+18005550199",      "call_leg_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "call_session_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "call_sec": 100,      "billed_sec": 120,      "is_telnyx_billable": true,      "rate": "0.002",      "rate_measured_in": "minutes",      "cost": "0.004",      "currency": "USD",      "record_type": "conference_participant_detail_record"    },    {      "id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "invoked_at": "2020-07-01T00:00:00Z",      "feature": "PREMIUM",      "tags": "tag1,tag2",      "billing_group_id": "01977831-abdd-4894-84f3-244385621424",      "billing_group_name": "Billing group name",      "connection_id": "1684947189014463919",      "connection_name": "Name of the connection with id specified in connection_id field",      "call_leg_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "call_session_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "is_telnyx_billable": true,      "rate": "0.002",      "rate_measured_in": "invocations",      "cost": "0.004",      "currency": "USD",      "record_type": "amd_detail_record"    },    {      "id": "0add777f-1549-46f7-84e9-ad7350f6aa97",      "verify_profile_id": "49000176-1ab2-8bc1-352e-4009f6c37f82",      "delivery_status": "pending",      "verification_status": "pending",      "destination_phone_number": "+13124515883",      "verify_channel_type": "sms",      "verify_channel_id": "5b7a8365-91f3-420a-befc-498d1efd6c20",      "created_at": "2021-07-08T00:00:41.000000+00:00",      "updated_at": "2021-07-08T00:00:41.000000+00:00",      "rate": "0.002",      "rate_measured_in": "number of occurrences",      "verify_usage_fee": "0.002",      "currency": "USD",      "record_type": "verification_detail_record"    },    {      "id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "created_at": "2020-07-01T00:00:00Z",      "closed_at": "2020-07-01T00:00:00Z",      "ip_address": "100.64.1.2",      "downlink_data": "0.1240",      "imsi": "311210393720093",      "mcc": "204",      "mnc": "69",      "currency": "USD",      "data_unit": "MB",      "data_rate": "0.06000",      "sim_group_name": "SIMBillingInfo test - otheraccount",      "sim_card_id": "7aa66686-b39f-456d-8edc-5b6cffb1432a",      "sim_group_id": "6c07e2e9-cbc0-49ba-ac0d-c59b59646bb1",      "sim_card_tags": "mytag",      "phone_number": "+15188490209",      "uplink_data": "0.7653",      "data_cost": "0.0292830",      "record_type": "sim_card_usage"    },    {      "id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "created_at": "2020-07-01T00:00:00Z",      "asset_id": "a46f4764-4ce4-4391-804c-02f00bc4ff9b",      "user_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "org_id": "3ca7bd3d-7d82-4e07-9df4-009123068320",      "action_type": "upload",      "link_channel_type": "message",      "link_channel_id": "2065f482-64b9-4680-a3a9-c6d3142efdf7",      "status": "failed",      "webhook_id": "b46f4764-4ce4-4391-804c-02f00bc4ff9b",      "rate": "0.0001",      "rate_measured_in": "events",      "cost": "0.004",      "currency": "USD",      "record_type": "media_storage"    }  ],  "meta": {    "total_pages": 3,    "total_results": 55,    "page_number": 2,    "page_size": 25  }}
```


# Search detail records

Search for any detail record across the Telnyx Platform

Search detail records API{"@context":"http://schema.org","@type":"TechArticle","headline":"Search detail records API","description":"Search for any detail record across the Telnyx Platform","url":"https://developers.telnyx.com/api/detail-records/search-detail-records","author":{"@type":"Organization","name":"Telnyx"},"publisher":{"@type":"Organization","name":"Telnyx","url":"https://www.telnyx.com","logo":{"@type":"ImageObject","url":"https://developers.telnyx.com/img/logo.svg","width":270,"height":108}}}Copy for LLMView as MarkdownSearch detail records
GET /detail_records
Search for any detail record across the Telnyx Platform
Request ​
Responses ​200: Successful